﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using rsi.Controls.iToolTip;

///
/// WRITTEN BY FLORIAN RAPPL, 2011
/// CODE IS FREE TO USE -- CPOL [ Code Project Open License ]
/// 

namespace Test
{
    public partial class Demo : Form
    {
        public Demo()
        {
            InitializeComponent();

            //Use a different DataProvider than the standard one - here we simulate some work
            internetToolTip1.DataProvider = new SampleDataProvider();

            //Since we use the BasicToolTipView we can also extend it with some animation like FadeIn for 500 ms
            (internetToolTip1.DataView as BasicToolTipView).Animation(BasicToolTipView.Effect.Fade, 500);

            //Use something different for the already build ToolTipTextBox
            //---
            toolTipTextBox1.LoadText = "Please wait!"; //This is useless here since we will get the result right away...
            BasicToolTipView btv = (toolTipTextBox1.ToolTipView as BasicToolTipView)
                .Animation(BasicToolTipView.Effect.Slide, 200); //We set the animation and use chaining

            btv.ForeColor = Color.Green; //Another color for the tooltip font to display
            btv.LoadColor = Color.White; //Quite useless here as well but the possibility exists

            btv.GradientColorOne = Color.LightBlue; //Sets a different gradient color (#1)
            btv.GradientColorTwo = Color.LightGray; // -- same -- (#2)
            //---
        }
    }
}
